/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pane;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.SlopeType;
import xfacthd.framedblocks.common.data.skippreds.CornerDir;
import xfacthd.framedblocks.common.data.skippreds.CullTest;
import xfacthd.framedblocks.common.data.skippreds.HalfDir;
import xfacthd.framedblocks.common.data.skippreds.pane.FloorBoardSkipPredicate;
import xfacthd.framedblocks.common.data.skippreds.pane.WallBoardSkipPredicate;

@CullTest(value={BlockType.FRAMED_CORNER_STRIP})
public final class CornerStripSkipPredicate
implements SideSkipPredicate {
    @Override
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        IFramedBlock block;
        Object object = adjState.m_60734_();
        if (object instanceof IFramedBlock && (object = (block = (IFramedBlock)object).getBlockType()) instanceof BlockType) {
            BlockType blockType = (BlockType)object;
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            SlopeType type = (SlopeType)((Object)state.m_61143_(PropertyHolder.SLOPE_TYPE));
            return switch (blockType) {
                case BlockType.FRAMED_CORNER_STRIP -> CornerStripSkipPredicate.testAgainstCornerStrip(dir, type, adjState, side);
                case BlockType.FRAMED_FLOOR_BOARD -> CornerStripSkipPredicate.testAgainstFloorBoard(dir, type, adjState, side);
                case BlockType.FRAMED_WALL_BOARD -> CornerStripSkipPredicate.testAgainstWallBoard(dir, type, adjState, side);
                default -> false;
            };
        }
        return false;
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_CORNER_STRIP})
    private static boolean testAgainstCornerStrip(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        SlopeType adjType = (SlopeType)((Object)adjState.m_61143_(PropertyHolder.SLOPE_TYPE));
        return CornerStripSkipPredicate.getHalfDir(dir, type, side).isEqualTo(CornerStripSkipPredicate.getHalfDir(adjDir, adjType, side.m_122424_())) || CornerStripSkipPredicate.getCornerDir(dir, type, side).isEqualTo(CornerStripSkipPredicate.getCornerDir(adjDir, adjType, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_FLOOR_BOARD})
    private static boolean testAgainstFloorBoard(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        boolean top = (Boolean)adjState.m_61143_((Property)FramedProperties.TOP);
        return CornerStripSkipPredicate.getHalfDir(dir, type, side).isEqualTo(FloorBoardSkipPredicate.getHalfDir(top, side.m_122424_()));
    }

    @CullTest.TestTarget(value={BlockType.FRAMED_WALL_BOARD})
    private static boolean testAgainstWallBoard(Direction dir, SlopeType type, BlockState adjState, Direction side) {
        Direction adjDir = (Direction)adjState.m_61143_((Property)FramedProperties.FACING_HOR);
        return CornerStripSkipPredicate.getHalfDir(dir, type, side).isEqualTo(WallBoardSkipPredicate.getHalfDir(adjDir, side.m_122424_()));
    }

    public static HalfDir getHalfDir(Direction dir, SlopeType type, Direction side) {
        Direction dirTwo;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TOP: {
                Direction direction = Direction.UP;
                break;
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = dirTwo = dir.m_122428_();
            }
        }
        if (side == dir) {
            return HalfDir.fromDirections(side, dirTwo);
        }
        if (side == dirTwo) {
            return HalfDir.fromDirections(side, dir);
        }
        return HalfDir.NULL;
    }

    public static CornerDir getCornerDir(Direction dir, SlopeType type, Direction side) {
        Direction dirTwo;
        switch (type) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case TOP: {
                Direction direction = Direction.UP;
                break;
            }
            case BOTTOM: {
                Direction direction = Direction.DOWN;
                break;
            }
            case HORIZONTAL: {
                Direction direction = dirTwo = dir.m_122428_();
            }
        }
        if (side.m_122434_() != dir.m_122434_() && side.m_122434_() != dirTwo.m_122434_()) {
            return CornerDir.fromDirections(side, dir, dirTwo);
        }
        return CornerDir.NULL;
    }
}

